/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.Scheduler;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public class ScheduledOpsCBridge {
    private static final String TRACE_MASKT = "XTIMBRGT";
    private static final String TRACE_MASKF = "XTIMBRGF";
    private static final String TRACE_MASKD = "XTIMBRGD";
    private static final HMC hmc = HMC.getHMC();

    public static void removeScheduledOperations(Schedulable schedulable) {
        Trace.trace(TRACE_MASKT, "-> ScheduledOperationsCBridge.removeScheduledOperations(" + schedulable + ")");
        try {
            Scheduler hmcScheduler = hmc.getScheduler();
            if (hmcScheduler != null) {
                ArrayList schedops = (ArrayList)hmcScheduler.getScheduledOperations(hmc, schedulable);
                Iterator iterator = schedops.iterator();
                while (iterator.hasNext()) {
                    ScheduledOperation schedop = (ScheduledOperation)iterator.next();
                    hmcScheduler.removeScheduledOperation(schedop);
                }
            } else {
                Trace.trace(TRACE_MASKF, "ScheduledOperationsCBridge.removeScheduledOperations(): hmcScheduler == null");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- ScheduledOperationsCBridge.removeScheduledOperations()");
    }

    public static ScheduledOperation[] getScheduledOperations(Schedulable scheduable) {
        Trace.trace(TRACE_MASKT, "-> ScheduledOperationsCBridge.getScheduledOperations(" + scheduable + ")");
        ScheduledOperation[] result = null;
        try {
            Scheduler hmcScheduler = hmc.getScheduler();
            if (hmcScheduler != null) {
                ArrayList schedopsList = (ArrayList)hmcScheduler.getScheduledOperations(hmc, scheduable);
                Trace.trace(TRACE_MASKF, "ScheduledOperationsCBridge.getScheduledOperations(): schedopsList.size() = " + schedopsList.size());
                Object[] objects = schedopsList.toArray();
                result = new ScheduledOperation[objects.length];
                for (int i = 0; i < objects.length; ++i) {
                    result[i] = (ScheduledOperation)objects[i];
                }
                Trace.trace(TRACE_MASKF, "ScheduledOperationsCBridge.getScheduledOperations(): result.length = " + result.length);
            } else {
                Trace.trace(TRACE_MASKF, "ScheduledOperationsCBridge.getScheduledOperations(): hmcScheduler == null");
            }
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKT, "<- ScheduledOperationsCBridge.getScheduledOperations()");
        return result;
    }
}

